
********************************************************************************
********************************************************************************
********************************************************************************
**** STATA Code for SDG Economy
**** Building the SDG economy: Needs, spending, and financing for universal achievement of the Sustainable Development Goals
**** Homi Kharas & John McArthur
**** Final data and do-files compiled by Selen Özdoğan
**** January 2020
********************************************************************************
**** 0. Define a program to clean country names
********************************************************************************
********************************************************************************
********************************************************************************

program define CLEAN_COUNTRY_NAMES
	quietly replace `1' = trim(`1')
	gen `1'_temp = `1'
	quietly replace `1'_temp = "Yemen, Rep." if strpos(`1', "Yemen") > 0 
	quietly replace `1'_temp = "Vietnam" if strpos(`1', "Viet") > 0
	quietly replace `1'_temp = "Venezuela, RB" if strpos(`1', "Venezuela") > 0
	quietly replace `1'_temp = "Macao SAR, China" if strpos(`1', "Macao") > 0
	quietly replace `1'_temp = "Hong Kong SAR, China" if strpos(`1', "Hong") > 0
	quietly replace `1'_temp = "China" if strpos(`1', "China") > 0 & strpos(`1', "Mainland") > 0 | `1' == "PRC"
	quietly replace `1'_temp = "China" if `1' == "China (People's Republic of)"
	quietly replace `1'_temp = "Lao PDR" if strpos(`1', "Lao") > 0
	quietly replace `1'_temp = "Korea, Dem. People’s Rep." if strpos(`1', "Korea") > 0 & (strpos(`1', "Dem") > 0 | strpos(`1', "North") > 0 | strpos(`1', "DPR") > 0 | strpos(`1', "N.") > 0)
	quietly replace `1'_temp = "Korea, Rep." if strpos(`1', "Korea") > 0 & ((strpos(`1', "Dem") == 0  & strpos(`1', "North") == 0 & strpos(`1', "DPR") == 0  & strpos(`1', "N.") == 0) | (strpos(`1', "South") > 0 | strpos(`1', "S.") > 0))
	quietly replace `1'_temp = "Iran, Islamic Rep." if `1' == "Iran, Islamic Republic of"
	quietly replace `1'_temp = "Hong Kong SAR, China" if strpos(`1', "Hong Kong") > 0
	quietly replace `1'_temp = "Gambia, The" if strpos(`1', "Gambia") > 0
	quietly replace `1'_temp = "Congo, Rep." if strpos(`1', "Congo") > 0 & strpos(`1', "Dem") == 0 & strpos(`1', "DR") == 0 & strpos(`1', "D.R") == 0 & strpos(`1', "D. R") == 0
	quietly replace `1'_temp = "Congo, Dem. Rep." if (strpos(`1', "Cong") > 0 & (strpos(`1', "Dem") > 0 | strpos(`1', "DR") > 0 | strpos(`1', "D.R") > 0 | strpos(`1', "D. R") > 0)) | "`1'" == "DRC"
	quietly replace `1'_temp = "Congo, Dem. Rep." if strpos(`1', "Zaire") > 0
	quietly replace `1'_temp = "Bahamas, The" if strpos(`1', "Bahamas") > 0 
	quietly replace `1'_temp = "Egypt, Arab Rep." if strpos(`1', "Egypt") > 0 
	quietly replace `1'_temp = "Cote d'Ivoire" if strpos(`1', "Ivoire") > 0 | strpos(`1', "Ivory") > 0
	quietly replace `1'_temp = "Bolivia" if strpos(`1', "Bolivia") > 0 
	quietly replace `1'_temp = "Tanzania" if strpos(`1', "Tanzania") > 0
	quietly replace `1'_temp = "Afghanistan" if strpos(`1', "Afghanistan") > 0
	quietly replace `1'_temp = "Sao Tome and Principe" if strpos(`1', "ncipe") > 0 | strpos(`1', "Tome") > 0
	quietly replace `1'_temp = "Iran, Islamic Rep." if strpos(`1', "Iran") > 0
	quietly replace `1'_temp = "St. Vincent and the Grenadines" if strpos(`1', "Vincent")> 0 & strpos(`1', "Grenadine")> 0
	quietly replace `1'_temp = "Venezuela, RB" if strpos(`1', "Venezuela") > 0
	quietly replace `1'_temp = "Central African Republic" if strpos(`1', "Central African") > 0  | `1' == "Cent. Af. Rep."
	quietly replace `1'_temp = "Kyrgyz Republic" if strpos(`1', "Kyrgyz") > 0 
	quietly replace `1'_temp = "Macedonia, FYR" if strpos(`1', "Macedonia") > 0 | strpos(`1', "Former Yugoslav Republic of")
	quietly replace `1'_temp = "Maldives" if strpos(`1', "Falkand") > 0 
	quietly replace `1'_temp = "Antigua and Barbuda" if strpos(`1', "Antigua") > 0 
	quietly replace `1'_temp = "Cabo Verde" if strpos(`1', "Verde") > 0 
	quietly replace `1'_temp = "Comoros" if strpos(`1', "Comoro") > 0
	quietly replace `1'_temp = "Guinea-Bissau" if strpos(`1', "Guinea") > 0 & strpos(`1', "Bissau") > 0
	quietly replace `1'_temp = "Haiti" if `1' == "Haïti"
	quietly replace `1'_temp = "Myanmar" if strpos(`1', "Burma") > 0
	quietly replace `1'_temp = "Syrian Arab Republic" if strpos(`1', "Syria") > 0
	quietly replace `1'_temp = "Brunei Darussalam" if strpos(`1', "Brunei") > 0 
	quietly replace `1'_temp = "St. Kitts and Nevis" if strpos(`1', "Kitts") >  0 & strpos(`1', "Nevis") > 0
	quietly replace `1'_temp = "Russian Federation" if strpos(`1', "Russia") > 0 
	quietly replace `1'_temp = "Micronesia, Fed. Sts." if strpos(`1', "Micronesia") > 0 
	quietly replace `1'_temp = "Timor-Leste" if strpos(`1', "Timor") > 0 
	quietly replace `1'_temp = "United States" if `1' == "United States of America" | `1' == "USA"
	quietly replace `1'_temp = "Bosnia and Herzegovina" if strpos(`1', "Bosnia") >  0 
	quietly replace `1'_temp = "West Bank and Gaza" if (strpos(`1', "Gaza") > 0 | strpos(`1', "West Bank") > 0) | strpos(`1', "Palestin") > 0 
	quietly replace `1'_temp = "Sint Maarten (Dutch part)" if strpos(`1', "Maarten") > 0 
	quietly replace `1'_temp = "Turks and Caicos Islands" if strpos(`1', "Turks") > 0 & strpos(`1', "Caicos") > 0 
	quietly replace `1'_temp = "United Kingdom" if strpos(`1', "United Kingdom") > 0 & strpos(`1', "Britain") > 0 
	quietly replace `1'_temp = "Virgin Islands (U.S.)" if strpos(`1', "Virgin") > 0 & (strpos(`1', "US") > 0 | strpos(`1', "U.S") > 0)
	quietly replace `1'_temp = "Slovak Republic" if `1' == "Slovakia"
	quietly replace `1'_temp = "St. Lucia" if strpos(`1', "Lucia") > 0
 	quietly replace `1'_temp = "Slovak Republic" if `1' == "Slovakia"
 	quietly replace `1'_temp = "Dominican Republic" if strpos(`1', "Dominican") > 0
	quietly replace `1'_temp = "United Kingdom" if `1' == "UK"
	quietly replace `1'_temp = "United States" if `1' == "US"
	quietly replace `1'_temp = "Libya" if strpos(`1', "Libya") > 0
	quietly replace `1'_temp = "Moldova" if strpos(`1', "Moldova") > 0
	quietly replace `1'_temp = "Trinidad and Tobago" if strpos(`1', "Trinidad") >  0 & strpos(`1', "Tobago") > 0
	quietly replace `1'_temp = "Papua New Guinea" if strpos(`1', "Papua") > 0 | `1' == "P. N. Guinea"
	quietly replace `1'_temp = "United Arab Emirates" if strpos(`1', "Emirates") > 0 | strpos(`1', "UAE") > 0
	quietly replace `1'_temp = "Curacao" if strpos(`1', "Cura") > 0 & strpos(`1', "ao") > 0 
	quietly replace `1'_temp = "Saudi Arabia" if strpos(`1', "Sa'udi") > 0 | strpos(`1', "Saudi") > 0 
	quietly replace `1'_temp = "Kuwait" if strpos(`1', "Kuwait") > 0 
	quietly replace `1'_temp = "Lebanon" if strpos(`1', "Lebanese") > 0 
	quietly replace `1'_temp = "Kosovo" if strpos(`1', "Kosovo") > 0 
	quietly replace `1'_temp = "Sudan" if strpos(`1', "Sudan") > 0 & strpos(`1', "South") == 0 
	quietly replace `1'_temp = "Germany" if strpos(`1', "Germany") > 0
	quietly replace `1'_temp = "Solomon Islands" if strpos(`1', "Solomon") > 0
	quietly replace `1'_temp = "Czech Republic" if (strpos(`1', "Czech") > 0 & strpos(`1', "R") > 0)
	quietly replace `1'_temp = "Dominican Republic" if (strpos(`1', "Dom") > 0 & strpos(`1', "Rep") > 0)
	quietly replace `1'_temp = "Equatorial Guinea" if (strpos(`1', "Guinea") > 0 & strpos(`1', "Eq") > 0)
	quietly replace `1'_temp = "South Africa" if (strpos(`1', "Africa") > 0 & strpos(`1', "S") > 0)
	quietly replace `1'_temp = "Bahrain" if strpos(`1', "Bahrain") > 0
	quietly replace `1'_temp = "Faroe Islands" if strpos(`1', "Faroe") > 0 | strpos(`1', "Faeroe ") > 0
	
	*** Show country names that were updated
	preserve
	keep if `1'_temp != `1'
	if _N > 0 {
		contract `1'_temp `1'
		list `1'_temp `1', ab(20) sep(100)
	}
	restore
	replace `1' = `1'_temp
	drop `1'_temp
end
